//persistent switches don't work on html5

//allow esc to be used for stuff
Scene_Map.prototype.isMenuCalled = function() {
    return Input.isTriggered('menu') || TouchInput.isCancelled() || Input.isTriggered('esc')
};

Window_Selectable.prototype.isCancelTriggered = function() {
    return Input.isRepeated('cancel') || Input.isRepeated('esc')
};

chgresolution = function() {
	var w = window.outerWidth - window.innerWidth + 1280
	var h = window.outerHeight - window.innerHeight + 720
	
//	var w = 1282
//	var h = 752
	
	switch (ConfigManager.resolution) {
	case 0:; w *= 0.5;h *= 0.5; break
	case 1:; w *= 0.6;h *= 0.6; break
	case 2:; w *= 0.7;h *= 0.7; break
	case 3:; w *= 0.8;h *= 0.8; break
	case 4:; w *= 0.9;h *= 0.9; break
//	case 5:; w *= 1;h *= 1; break
	case 6:; w *= 1.2;h *= 1.2; break
	case 7:; w *= 1.4;h *= 1.4; break
	case 8:; w *= 1.6;h *= 1.6; break
	case 9:; w *= 1.8;h *= 1.8; break
	case 10:; w *= 2.0;h *= 2.0; break
	}
/*
	if (!Utils.isOptionValid('test')) {
		window.resizeTo(w,h);
	}
*/
	window.resizeTo(w,h);
	
	var x = (screen.width - w) / 2
	var y = (screen.height - h) * 2 / 5
	
	if (!Utils.isOptionValid('test')) {
		window.moveTo(x,y);
	}
	else { //for debug/testing purposes
		window.moveTo(1000,0);
	}
}


puttemptokeys = function() {
	if (v(40) == 2) {
		for (var i = 387; i <= 396; i++) {
			switch (i) {
			case 387:
				ConfigManager.keysseek = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.keysseek.push(v(i)[j])
				}
				break
			case 388:
				ConfigManager.keysleft = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.keysleft.push(v(i)[j])
				}
				break
			case 389:
				ConfigManager.keysup = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.keysup.push(v(i)[j])
				}
				break
			case 390:
				ConfigManager.keysright = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.keysright.push(v(i)[j])
				}
				break
			case 391:
				ConfigManager.keysdown = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.keysdown.push(v(i)[j])
				}
				break
			case 392:
				ConfigManager.keyspageup = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.keyspageup.push(v(i)[j])
				}
				break
			case 393:
				ConfigManager.keyspagedown = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.keyspagedown.push(v(i)[j])
				}
				break
			case 394:
				ConfigManager.keysok = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.keysok.push(v(i)[j])
				}
				break
			case 395:
				ConfigManager.keyscancel = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.keyscancel.push(v(i)[j])
				}
				break
			case 396:
				ConfigManager.keysshift = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.keysshift.push(v(i)[j])
				}
				break
			}
		}
	}
}


putkeystotemp = function() {
	if (v(40) == 2) {
		for (var i = 387; i <= 396; i++) {
			vset(i,[])
			switch (i) {
			case 387:
				for (var j = 0; j < ConfigManager.keysseek.length; j++) {
					v(i).push(ConfigManager.keysseek[j])
				}
				break
			case 388:
				for (var j = 0; j < ConfigManager.keysleft.length; j++) {
					v(i).push(ConfigManager.keysleft[j])
				}
				break
			case 389:
				for (var j = 0; j < ConfigManager.keysup.length; j++) {
					v(i).push(ConfigManager.keysup[j])
				}
				break
			case 390:
				for (var j = 0; j < ConfigManager.keysright.length; j++) {
					v(i).push(ConfigManager.keysright[j])
				}
				break
			case 391:
				for (var j = 0; j < ConfigManager.keysdown.length; j++) {
					v(i).push(ConfigManager.keysdown[j])
				}
				break
			case 392:
				for (var j = 0; j < ConfigManager.keyspageup.length; j++) {
					v(i).push(ConfigManager.keyspageup[j])
				}
				break
			case 393:
				for (var j = 0; j < ConfigManager.keyspagedown.length; j++) {
					v(i).push(ConfigManager.keyspagedown[j])
				}
				break
			case 394:
				for (var j = 0; j < ConfigManager.keysok.length; j++) {
					v(i).push(ConfigManager.keysok[j])
				}
				break
			case 395:
				for (var j = 0; j < ConfigManager.keyscancel.length; j++) {
					v(i).push(ConfigManager.keyscancel[j])
				}
				break
			case 396:
				for (var j = 0; j < ConfigManager.keysshift.length; j++) {
					v(i).push(ConfigManager.keysshift[j])
				}
				break
			}
		}
	}
}


putkeystoprev = function() {
	if (v(40) == 2) {
		for (var i = 407; i <= 416; i++) {
			vset(i,[])
			switch (i) {
			case 407:
				for (var j = 0; j < ConfigManager.keysseek.length; j++) {
					v(i).push(ConfigManager.keysseek[j])
				}
				break
			case 408:
				for (var j = 0; j < ConfigManager.keysleft.length; j++) {
					v(i).push(ConfigManager.keysleft[j])
				}
				break
			case 409:
				for (var j = 0; j < ConfigManager.keysup.length; j++) {
					v(i).push(ConfigManager.keysup[j])
				}
				break
			case 410:
				for (var j = 0; j < ConfigManager.keysright.length; j++) {
					v(i).push(ConfigManager.keysright[j])
				}
				break
			case 411:
				for (var j = 0; j < ConfigManager.keysdown.length; j++) {
					v(i).push(ConfigManager.keysdown[j])
				}
				break
			case 412:
				for (var j = 0; j < ConfigManager.keyspageup.length; j++) {
					v(i).push(ConfigManager.keyspageup[j])
				}
				break
			case 413:
				for (var j = 0; j < ConfigManager.keyspagedown.length; j++) {
					v(i).push(ConfigManager.keyspagedown[j])
				}
				break
			case 414:
				for (var j = 0; j < ConfigManager.keysok.length; j++) {
					v(i).push(ConfigManager.keysok[j])
				}
				break
			case 415:
				for (var j = 0; j < ConfigManager.keyscancel.length; j++) {
					v(i).push(ConfigManager.keyscancel[j])
				}
				break
			case 416:
				for (var j = 0; j < ConfigManager.keysshift.length; j++) {
					v(i).push(ConfigManager.keysshift[j])
				}
				break
			}
		}
	}
}


puttemptopads = function() {
	if (v(40) == 3) {
		for (var i = 387; i <= 396; i++) {
			switch (i) {
			case 387:
				ConfigManager.padsseek = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.padsseek.push(v(i)[j])
				}
				break
			case 388:
				ConfigManager.padsleft = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.padsleft.push(v(i)[j])
				}
				break
			case 389:
				ConfigManager.padsup = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.padsup.push(v(i)[j])
				}
				break
			case 390:
				ConfigManager.padsright = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.padsright.push(v(i)[j])
				}
				break
			case 391:
				ConfigManager.padsdown = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.padsdown.push(v(i)[j])
				}
				break
			case 392:
				ConfigManager.padspageup = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.padspageup.push(v(i)[j])
				}
				break
			case 393:
				ConfigManager.padspagedown = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.padspagedown.push(v(i)[j])
				}
				break
			case 394:
				ConfigManager.padsok = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.padsok.push(v(i)[j])
				}
				break
			case 395:
				ConfigManager.padscancel = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.padscancel.push(v(i)[j])
				}
				break
			case 396:
				ConfigManager.padsshift = []
				for (var j = 0; j < v(i).length; j++) {
					ConfigManager.padsshift.push(v(i)[j])
				}
				break
			}
		}
	}
}


putpadstotemp = function() {
	if (v(40) == 3) {
		for (var i = 387; i <= 396; i++) {
			vset(i,[])
			switch (i) {
			case 387:
				for (var j = 0; j < ConfigManager.padsseek.length; j++) {
					v(i).push(ConfigManager.padsseek[j])
				}
				break
			case 388:
				for (var j = 0; j < ConfigManager.padsleft.length; j++) {
					v(i).push(ConfigManager.padsleft[j])
				}
				break
			case 389:
				for (var j = 0; j < ConfigManager.padsup.length; j++) {
					v(i).push(ConfigManager.padsup[j])
				}
				break
			case 390:
				for (var j = 0; j < ConfigManager.padsright.length; j++) {
					v(i).push(ConfigManager.padsright[j])
				}
				break
			case 391:
				for (var j = 0; j < ConfigManager.padsdown.length; j++) {
					v(i).push(ConfigManager.padsdown[j])
				}
				break
			case 392:
				for (var j = 0; j < ConfigManager.padspageup.length; j++) {
					v(i).push(ConfigManager.padspageup[j])
				}
				break
			case 393:
				for (var j = 0; j < ConfigManager.padspagedown.length; j++) {
					v(i).push(ConfigManager.padspagedown[j])
				}
				break
			case 394:
				for (var j = 0; j < ConfigManager.padsok.length; j++) {
					v(i).push(ConfigManager.padsok[j])
				}
				break
			case 395:
				for (var j = 0; j < ConfigManager.padscancel.length; j++) {
					v(i).push(ConfigManager.padscancel[j])
				}
				break
			case 396:
				for (var j = 0; j < ConfigManager.padsshift.length; j++) {
					v(i).push(ConfigManager.padsshift[j])
				}
				break
			}
		}
	}
}


putpadstoprev = function() {
	if (v(40) == 3) {
		for (var i = 407; i <= 416; i++) {
			vset(i,[])
			switch (i) {
			case 407:
				for (var j = 0; j < ConfigManager.padsseek.length; j++) {
					v(i).push(ConfigManager.padsseek[j])
				}
				break
			case 408:
				for (var j = 0; j < ConfigManager.padsleft.length; j++) {
					v(i).push(ConfigManager.padsleft[j])
				}
				break
			case 409:
				for (var j = 0; j < ConfigManager.padsup.length; j++) {
					v(i).push(ConfigManager.padsup[j])
				}
				break
			case 410:
				for (var j = 0; j < ConfigManager.padsright.length; j++) {
					v(i).push(ConfigManager.padsright[j])
				}
				break
			case 411:
				for (var j = 0; j < ConfigManager.padsdown.length; j++) {
					v(i).push(ConfigManager.padsdown[j])
				}
				break
			case 412:
				for (var j = 0; j < ConfigManager.padspageup.length; j++) {
					v(i).push(ConfigManager.padspageup[j])
				}
				break
			case 413:
				for (var j = 0; j < ConfigManager.padspagedown.length; j++) {
					v(i).push(ConfigManager.padspagedown[j])
				}
				break
			case 414:
				for (var j = 0; j < ConfigManager.padsok.length; j++) {
					v(i).push(ConfigManager.padsok[j])
				}
				break
			case 415:
				for (var j = 0; j < ConfigManager.padscancel.length; j++) {
					v(i).push(ConfigManager.padscancel[j])
				}
				break
			case 416:
				for (var j = 0; j < ConfigManager.padsshift.length; j++) {
					v(i).push(ConfigManager.padsshift[j])
				}
				break
			}
		}
	}
}




Scene_Options.prototype.create = function() {
	sset(138, ConfigManager.gamepad)
	vset(40,0) //set start menu to 0

    Scene_MenuBase.prototype.create.call(this);
    this.createOptionsWindow();
	this.createHelpWindow();
	this._optionsWindow.setHelpWindow(this._helpWindow);
	
	if (ts(1,3,2)) {
		$gameSelfSwitches.setValue([3, 1, 2], false)
		this._optionsWindow.select(4)
	}
	
};

Scene_Options.prototype.createOptionsWindow = function() {
    this._optionsWindow = new Window_Options();
    this._optionsWindow.setHandler('cancel', this.cancelOptions.bind(this));
    this.addWindow(this._optionsWindow);



	this.spriteBack = new Sprite(ImageManager.loadPicture('zBtnBack'))
	this.spriteBack.x = -ConfigManager.movebtn //move x
	this.addChild(this.spriteBack)
	if (!ConfigManager.touchbuttons) {this.spriteBack.visible = false}
	
	this.sprite = new Sprite(ImageManager.loadPicture('zBtnPrevNext'))
	this.sprite.visible = false
	this.addChild(this.sprite)
	
	this.spriteU = new Sprite(ImageManager.loadPicture('zBtnPrevNextU'))
	this.spriteU.visible = false
	this.addChild(this.spriteU)
	
	this.spriteD = new Sprite(ImageManager.loadPicture('zBtnPrevNextD'))
	this.spriteD.visible = false
	this.addChild(this.spriteD)
};

var nk_Scene_Options_btns = Scene_Options.prototype.update
Scene_Options.prototype.update = function() {
	nk_Scene_Options_btns.call(this)
	
	if (ConfigManager.touchbuttons && this._optionsWindow) {
		this.spriteBack.visible = true
		
		if (this.spriteBack.x != -ConfigManager.movebtn) {this.spriteBack.x = -ConfigManager.movebtn}
		
		var topRow = this._optionsWindow.topRow();
		var maxTopRow = this._optionsWindow.maxTopRow();
		
		if (!this.spriteU) {
			this.sprite = new Sprite(ImageManager.loadPicture('zBtnPrevNext'))
			this.sprite.visible = false
			this.addChild(this.sprite)
			
			this.spriteU = new Sprite(ImageManager.loadPicture('zBtnPrevNextU'))
			this.spriteU.visible = false
			this.addChild(this.spriteU)
			
			this.spriteD = new Sprite(ImageManager.loadPicture('zBtnPrevNextD'))
			this.spriteD.visible = false
			this.addChild(this.spriteD)
		}
		
		
		if (maxTopRow > 0 && topRow < maxTopRow && topRow > 0) {
			this.sprite.visible = true
			this.spriteU.visible = false
			this.spriteD.visible = false
		}
		else if (topRow > 0) {
			this.sprite.visible = false
			this.spriteU.visible = true
			this.spriteD.visible = false
		}
		else if (maxTopRow > 0 && topRow < maxTopRow) {
			this.sprite.visible = false
			this.spriteU.visible = false
			this.spriteD.visible = true
		}
	}
	else if (this.sprite) {
		this.spriteBack.visible = false
		this.sprite.visible = false
		if (this.spriteU) {
			this.spriteU.visible = false
			this.spriteD.visible = false
		}
	}
}

Scene_Options.prototype.cancelOptions = function() {
	if (!ts(1,3,1) && v(40) == 0) { //not if rebinding keys
		Input.clear()
		this.popScene()
	}
}


Window_Options.prototype.processCancel = function() {
    SoundManager.playCancel();
    this.updateInputData();
	if (ts(1,3,1)) { //inputing keybind
		$gameSelfSwitches.setValue([3, 1, 1], false)
		this.refresh()
	}
	else {
		if (v(40) == 0) {
			this.deactivate();
			this.callCancelHandler();
		}
		else {
			ConfigManager.gamepad = s(138) //enable or disable gamepad
			puttemptokeys() //only runs if menu is 2
			puttemptopads() //only runs if menu is 3
			var last = 1
			switch (v(40)) {
			case 1:;last = 0;	break
				break
			case 2:;last = 2;	break
				break
			case 3:;last = 3;	break
				break
			case 4:;last = 1;	break
			}
			vset(40,0)
			this._scrollY = 0
			this.refresh()
			this.select(last)
		}
	}
	Input.clear()
};


chgkeybind = function(input) {
	if (v(40) == 2) {
		for (var i = 387; i <= 396; i++) {
			RemoveFromArray(i,v(398))
		}
		if (v(398) == "esc") {
		}
		else if (!v(input).includes(v(398))) {
			v(input).push(v(398))
		}
	}
	else {
		for (var i = 387; i <= 396; i++) {
			RemoveFromArray(i,v(397))
		}
		if (v(397) == "esc") {
		}
		else if (!v(input).includes(v(397))) {
			v(input).push(v(397))
		}
	}
}


var nk_Window_Options_update = Window_Options.prototype.update
Window_Options.prototype.update = function(wrap) {
	if (!ts(1,3,1)) { //not input new keybind
		nk_Window_Options_update.call(this, wrap)
		if (this.index() <= 11 && Input.isTriggered('shift') && //clear keybinds
		(v(40) == 2 || v(40) == 3)) {
			switch (this.commandSymbol(this.index())) {
			case 'chgseek':
				vset(387,[])
				break
			case 'chgup':
				vset(389,[])
				break
			case 'chgleft':
				vset(388,[])
				break
			case 'chgright':
				vset(390,[])
				break
			case 'chgdown':
				vset(391,[])
				break
			case 'chgpgup':
				vset(392,[])
				break
			case 'chgpgdown':
				vset(393,[])
				break
			case 'chgok':
				vset(394,[])
				break
			case 'chgcancel':
				vset(395,[])
				break
			case 'chgshift':
				vset(396,[])
				break
			}

			SoundManager.playOk()
			this.refresh()
			Input.clear()
		}
	}
	else { //choosing new bind
		if (Input._pressedTime > 0) {
			vset(397,0)
			vset(398,0)
		}
		if (Input._latestButton && Input._pressedTime === 0 &&
		((v(40) == 2 && v(398) != 0) || (v(40) == 3 && v(397) != 0))) {
			switch (this.commandSymbol(this.index())) { //set keybinds
			case 'chgseek':
				chgkeybind(387)
				break
			case 'chgup':
				chgkeybind(389)
				break
			case 'chgleft':
				chgkeybind(388)
				break
			case 'chgright':
				chgkeybind(390)
				break
			case 'chgdown':
				chgkeybind(391)
				break
			case 'chgpgup':
				chgkeybind(392)
				break
			case 'chgpgdown':
				chgkeybind(393)
				break
			case 'chgok':
				chgkeybind(394)
				break
			case 'chgcancel':
				chgkeybind(395)
				break
			case 'chgshift':
				chgkeybind(396)
				break
			}

			SoundManager.playOk()
			$gameSelfSwitches.setValue([3, 1, 1], false) //not keybinding anymore
			this.refresh()
			Input.clear()
		}
		else if (TouchInput.isCancelled()) {
			SoundManager.playCancel()
			$gameSelfSwitches.setValue([3, 1, 1], false)
			this.refresh()
		}
	}
};



Window_Options.prototype.windowWidth = function() {
    return 692;
};

Window_Options.prototype.updatePlacement = function() {
    this.x = 62
	if (Utils.isMobileDevice()) {
		this.y = 63
	}
	else {
		this.y = 28
	}
};

Window_Options.prototype.windowHeight = function() {
	if (Utils.isMobileDevice()) { //controls visible rows!
		return 377 //(72 is height of 1 row)
	}
	else {
		return 448
	}
//    return (this.numVisibleRows() * 72) + this.standardPadding() * 2 + 1;
//    return this.fittingHeight(this.numVisibleRows());
};


ConfigManager.touchbuttons = true
ConfigManager.gamepad = true
ConfigManager.port = true
ConfigManager.npcport = true
ConfigManager.movebtn = 0
ConfigManager.resolution = 5
ConfigManager.gamepadfocus = false

setdefaultkeys = function() {
	ConfigManager.keysleft = ['left','a','num4'] //left
	ConfigManager.keysup = ['up','w','num8'] //up
	ConfigManager.keysright = ['right','d','num6'] //right
	ConfigManager.keysdown = ['down','s','num2'] //down
	ConfigManager.keyspageup = ['pageup','q','num9'] //pageup (UR)
	ConfigManager.keyspagedown = ['pagedown','e','num3'] //pagedown (DR)
	ConfigManager.keysok = ['z','enter','space'] //ok
	ConfigManager.keyscancel = ['x','backspace', 'alt', 'num0'] //cancel
	ConfigManager.keysshift = ['shift','numdot'] //shift
	ConfigManager.keysseek = ['ctrl','numplus'] //shift
}

setdefaultkeys()

setdefaultpads = function() {
	ConfigManager.padsleft = ['padleft'] //left
	ConfigManager.padsup = ['padup'] //up
	ConfigManager.padsright = ['padright'] //right
	ConfigManager.padsdown = ['paddown'] //down
	ConfigManager.padspageup = ['padlb'] //pageup
	ConfigManager.padspagedown = ['padrb'] //pagedown
	ConfigManager.padsok = ['pada'] //ok
	ConfigManager.padscancel = ['padb','padstart'] //cancel
	ConfigManager.padsshift = ['padx','padsel'] //shift
	ConfigManager.padsseek = ['pady'] //shift
}

setdefaultpads()



var nkConfigManager_makedata = ConfigManager.makeData; //stores the data to config
ConfigManager.makeData = function() {
	var config = nkConfigManager_makedata.call(this);
	config.touchbuttons = this.touchbuttons;
	config.gamepad = this.gamepad;
	config.movebtn = this.movebtn;
	config.port = this.port;
	config.npcport = this.npcport;
	config.resolution = this.resolution;
	config.initialsetup = this.initialsetup;
	config.gamepadfocus = this.gamepadfocus;
	config.soundsgross = this.soundsgross;

	config.keysleft = this.keysleft;
	config.keysup = this.keysup;
	config.keysright = this.keysright;
	config.keysdown = this.keysdown;
	config.keyspageup = this.keyspageup;
	config.keyspagedown = this.keyspagedown;
	config.keysok = this.keysok;
	config.keyscancel = this.keyscancel;
	config.keysshift = this.keysshift;
	config.keysseek = this.keysseek;

	config.padsleft = this.padsleft;
	config.padsup = this.padsup;
	config.padsright = this.padsright;
	config.padsdown = this.padsdown;
	config.padspageup = this.padspageup;
	config.padspagedown = this.padspagedown;
	config.padsok = this.padsok;
	config.padscancel = this.padscancel;
	config.padsshift = this.padsshift;
	config.padsseek = this.padsseek;
	return config;
};

var nkConfigManager_applyData = ConfigManager.applyData; //loads the data from config
ConfigManager.applyData = function(config) {
	nkConfigManager_applyData.call(this, config);
	this.touchbuttons = this.readFlag(config, 'touchbuttons');
	this.gamepad = this.readFlag(config, 'gamepad');
	this.movebtn = this.readValue(config, 'movebtn');
	this.port = this.readFlag(config, 'port');
	this.npcport = this.readFlag(config, 'npcport');
	this.resolution = this.readValue(config, 'resolution');
	this.initialsetup = this.readFlag(config, 'initialsetup');
	this.gamepadfocus = this.readFlag(config, 'gamepadfocus');
	this.soundsgross = this.readFlag(config, 'soundsgross');

	this.keysleft = this.readKeys(config, 'keysleft');
	this.keysup = this.readKeys(config, 'keysup');
	this.keysright = this.readKeys(config, 'keysright');
	this.keysdown = this.readKeys(config, 'keysdown');
	this.keyspageup = this.readKeys(config, 'keyspageup');
	this.keyspagedown = this.readKeys(config, 'keyspagedown');
	this.keysok = this.readKeys(config, 'keysok');
	this.keyscancel = this.readKeys(config, 'keyscancel');
	this.keysshift = this.readKeys(config, 'keysshift');
	this.keysseek = this.readKeys(config, 'keysseek');

	this.padsleft = this.readKeys(config, 'padsleft');
	this.padsup = this.readKeys(config, 'padsup');
	this.padsright = this.readKeys(config, 'padsright');
	this.padsdown = this.readKeys(config, 'padsdown');
	this.padspageup = this.readKeys(config, 'padspageup');
	this.padspagedown = this.readKeys(config, 'padspagedown');
	this.padsok = this.readKeys(config, 'padsok');
	this.padscancel = this.readKeys(config, 'padscancel');
	this.padsshift = this.readKeys(config, 'padsshift');
	this.padsseek = this.readKeys(config, 'padsseek');
};



ConfigManager.readValue = function(config, name) {
    var value = config[name];
    if (value !== undefined) {
        return value
    } else {
        return 0
    }
};



ConfigManager.readKeys = function(config, name) {
    var value = config[name];
    if (value !== undefined) { //value is defined
        return value
    } else {
		switch (name) {
		case 'keysleft':;		return ['left','a','num4'];			break
		case 'keysup':;			return ['up','w','num8'];			break
		case 'keysright':;		return ['right','d','num6'];		break
		case 'keysdown':;		return ['down','s','num2'];			break
		case 'keyspageup':;		return ['pageup','num9'];			break
		case 'keyspagedown':;	return ['pagedown','num3'];			break
		case 'keysok':;			return ['z','enter'];				break
		case 'keyscancel':;		return ['x','num0', 'backspace'];	break
		case 'keysshift':;		return ['shift','numdot'];			break
		case 'keysseek':;		return ['ctrl','num1'];				break

		case 'padsleft':;		return ['padleft'];					break
		case 'padsup':;			return ['padup'];					break
		case 'padsright':;		return ['padright'];				break
		case 'padsdown':;		return ['paddown'];					break
		case 'padspageup':;		return ['padlb'];					break
		case 'padspagedown':;	return ['padrb'];					break
		case 'padsok':;			return ['pada'];					break
		case 'padscancel':;		return ['padb','padstart'];			break
		case 'padsshift':;		return ['padx','padsel'];			break
		case 'padsseek':;		return ['pady'];					break

		}
        return []
    }
};





Object.defineProperty(ConfigManager, 'gamepadtemp', {
    get: function() {
        return s(138);
    },
    set: function(value) {
        sset(138, value);
		if (s(138)) {ConfigManager.gamepad = true}
    },
    configurable: true
});



Object.defineProperty(ConfigManager, 'savelabel', {
    get: function() {
        return s(34);
    },
    set: function(value) {
        sset(34, value);
    },
    configurable: true
});








Window_Options.prototype.makeCommandList = function() {
	if (v(40) == 0) {
		this.addCommand("> General Settings", 'general');
		this.addCommand("> Audio Settings", 'audio');
		this.addCommand("> Change Keyboard Bindings", 'keybinds');
		this.addCommand("> Change Gamepad Bindings", 'padbinds', ConfigManager.gamepad);
		this.addCommand("> Delete Savefiles", 'delete');
	}
	else if (v(40) == 4) {
		this.addCommand(TextManager.seVolume, 'seVolume');
		this.addCommand(TextManager.bgsVolume, 'bgsVolume');
		this.addCommand("Fleshy Sounds", 'soundsgross');
	}
	else if (v(40) == 1) {
		if (!Utils.isMobileDevice()) {this.addCommand("Full Screen", 'fullscreen');		}
		if (!Utils.isMobileDevice()) {this.addCommand("Screen Resolution", 'resolution');		}
		if (!Utils.isMobileDevice()) {this.addCommand("HUD Buttons", 'touchbuttons');	}
		if (!Utils.isMobileDevice()) {this.addCommand("Offset HUD Buttons", 'movebtn');	}

		this.addCommand("Player Portrait", 'port');
		this.addCommand("NPC Portraits", 'npcport');
		this.addCommand("Use Gamepad", 'gamepadtemp');
		this.addCommand("Window Focus Gamepad", 'gamepadfocus');
		this.addCommand("Savefile Label", 'savelabel');
	}
	else if (v(40) == 2 || v(40) == 3) {
		this.addCommand("Up", 'chgup');
		this.addCommand("Left", 'chgleft');
		this.addCommand("Down", 'chgdown');
		this.addCommand("Right", 'chgright');
		this.addCommand("Page Up", 'chgpgup');
		this.addCommand("Page Down", 'chgpgdown');
		this.addCommand("Confirm", 'chgok');
		this.addCommand("Cancel/Menu", 'chgcancel');
		this.addCommand("Log Display", 'chgshift');
		this.addCommand("Seek", 'chgseek');
		this.addCommand("> Reset to Previous Keys", 'prevkeys');
		this.addCommand("> Reset to Default Keys", 'defaultkeys');
	}
};

Window_Options.prototype.drawItem = function(index) {
    var rect = this.itemRectForText(index);
    var statusWidth = this.statusWidth();
    var titleWidth = rect.width - statusWidth;
    this.resetTextColor();
    this.changePaintOpacity(this.isCommandEnabled(index));
		if (Utils.isMobileDevice()) {this.contents.fontSize = 20}
    this.drawText(this.commandName(index), rect.x, rect.y + 18, titleWidth + 100, 'left');
    this.drawText(this.statusText(index), titleWidth, rect.y + 18, statusWidth, 'right');
};

Window_Options.prototype.statusWidth = function() {
    return 490;
};

capkeybind = function(a) {
	switch (a) {
	case 'pageup':;			return "PgUp";			break
	case 'pagedown':;		return "PgDn";			break
	case 'numdot':;			return "Num(.)";		break
	case 'numplus':;		return "Num(+)";		break
	case 'numminus':;		return "Num(-)";		break
	case 'numslash':;		return "Num(/)";		break
	case 'numstar':;		return "Num(*)";		break
	case 'pada':;			return "A";				break
	case 'padb':;			return "B";				break
	case 'padx':;			return "X";				break
	case 'pady':;			return "Y";				break
	case 'padlt':;			return "LT";			break
	case 'padlb':;			return "LB";			break
	case 'padrt':;			return "RT";			break
	case 'padrb':;			return "RB";			break
	case 'padsel':;			return "Select";		break
	case 'padstart':;		return "Start";			break
	case 'padl3':;			return "L3";			break
	case 'padr3':;			return "R3";			break
	case 'padup':;			return "Up";			break
	case 'paddown':;		return "Down";			break
	case 'padleft':;		return "Left";			break
	case 'padright':;		return "Right";			break
	}
	if (a && a != "") {return a.charAt(0).toUpperCase() + a.slice(1)}
	else {return a}
}

showkeybinds = function(array) {
	var txt = ""
	var a = ""
	for (var i = 0; i < array.length; i++) {
		a = array[i]
		a = capkeybind(a)
		txt += a
		if (txt != "") {txt += ", "}
	}
	txt = txt.slice(0,-2)
	
	if (ts(1,3,1)) {
		if (txt != "") {
			txt += ","
		}
		txt += "_"
	}
	
	return txt
}

Window_Options.prototype.statusText = function(index) {
    var symbol = this.commandSymbol(index);
    var value = this.getConfigValue(symbol);
    if (this.isVolumeSymbol(symbol)) {
        return this.volumeStatusText(value);
	}
	else if (symbol == 'fullscreen') {return 'Toggle'}
	else if (symbol == 'touchbuttons') {
		if (ConfigManager.touchbuttons) {return "Show Buttons"}
		else {return "Don't Show Buttons"}
	}
	else if (symbol == 'gamepadfocus') {
		if (ConfigManager.gamepadfocus) {return "Works while Inactive"}
		else {return "Only while Active"}
	}
	else if (symbol == 'port') {
		if (ConfigManager.port) {return "Show Main Portrait"}
		else {return "Hide Main Portrait"}
	}
	else if (symbol == 'soundsgross') {
		if (ConfigManager.soundsgross) {return "Mute Sounds"}
		else {return "Play Sounds"}
	}
	else if (symbol == 'npcport') {
		if (ConfigManager.npcport) {return "Show NPC Portraits"}
		else {return "Hide NPC Portraits"}
	}
	else if (symbol == 'movebtn') {
		return ConfigManager.movebtn + " Pixels"
	}
	else if (symbol == 'savelabel') {
		if (s(34)) {return "Custom"} //uses switch
		else {return "Default"}
	}
	else if (symbol == 'gamepadtemp') {
		if (s(138)) {return "Gamepad Enabled"} //uses switch
		else {return "Gamepad Disabled"}
	}
	else if (symbol == 'delete' || symbol == 'defaultkeys' || symbol == 'prevkeys' ||
	symbol == 'keybinds' || symbol == 'padbinds' || symbol == 'general' || symbol == 'audio') {
		return ""
	}
	else if (symbol == 'resolution') {
		switch (ConfigManager.resolution) {
		case 0:; return "x0.5"; break
		case 1:; return "x0.6"; break
		case 2:; return "x0.7"; break
		case 3:; return "x0.8"; break
		case 4:; return "x0.9"; break
		case 5:; return "x1.0"; break
		case 6:; return "x1.2"; break
		case 7:; return "x1.4"; break
		case 8:; return "x1.6"; break
		case 9:; return "x1.8"; break
		case 10:; return "x2.0"; break
		}
    }
	else if (symbol == 'chgup') {
		return showkeybinds(v(389))
	}
	else if (symbol == 'chgleft') {
		return showkeybinds(v(388))
	}
	else if (symbol == 'chgright') {
		return showkeybinds(v(390))
	}
	else if (symbol == 'chgdown') {
		return showkeybinds(v(391))
	}
	else if (symbol == 'chgpgup') {
		return showkeybinds(v(392))
	}
	else if (symbol == 'chgpgdown') {
		return showkeybinds(v(393))
	}
	else if (symbol == 'chgok') {
		return showkeybinds(v(394))
	}
	else if (symbol == 'chgcancel') {
		return showkeybinds(v(395))
	}
	else if (symbol == 'chgshift') {
		return showkeybinds(v(396))
	}
	else if (symbol == 'chgseek') {
		return showkeybinds(v(387))
	}
	else {
        return this.booleanStatusText(value);
    }
};

Window_Options.prototype.isVolumeSymbol = function(symbol) {
    return symbol.contains('Volume');
};

Window_Options.prototype.booleanStatusText = function(value) {
    return value ? 'ON' : 'OFF';
};

Window_Options.prototype.volumeStatusText = function(value) {
	var slots = value / 5
	var txt = ""
	for (var i = 1; i <= slots; i++) {
//		txt += "▰"
		txt += "||"
	}
	for (var i = 1; i <= 20-slots; i++) {
//		txt += "▱"
		txt += "--"
	}
	
	var txt2 = value + '%'
	while (txt2.length < 4) {
		txt2 = " " + txt2
	}
	
	txt += "  " + txt2
	return txt
};

Window_Help.prototype.setWText = function(txt) {
      this.setText("<WordWrap>" + txt)
};

Window_Options.prototype.updateHelp = function() {
	var a = "\n\n"
	if (v(40) == 2) { //shift binds
		if (ConfigManager.keysshift.length > 0) {
			for (var i = 0; i < ConfigManager.keysshift.length; i++) {
				a += capkeybind(ConfigManager.keysshift[i]) + ", "
			}
			a = a.slice(0,-2)
			a += ": Clear assigned keybinds\n"
		}
	}
	else {
		if (ConfigManager.padsshift.length > 0) {
			for (var i = 0; i < ConfigManager.padsshift.length; i++) {
				a += capkeybind(ConfigManager.padsshift[i]) + ", "
			}
			a = a.slice(0,-2)
			a += ": Clear assigned keybinds\n"
		}
	}
	a += "Esc: Cancel keybind"
	
	var keybind = "keybinds"
	if (v(40) == 3) {keybind = "gamepad bindings"}

	var symbol = this.commandSymbol(this.index());
	if (symbol == 'seVolume') {		this._helpWindow.setWText("Change sound effect volume.")}
	if (symbol == 'bgsVolume') {	this._helpWindow.setWText("Change ambient background sound volume.")}
	if (symbol == 'fullscreen') {	this._helpWindow.setWText("Toggle between fullscreen or window view.")}
	if (symbol == 'touchbuttons') {	this._helpWindow.setWText("Show or hide mouse/touchpad buttons.\n\nTurn this on if you want to be able to play using only mouse or touchpad (keyboard/gamepad controls will still work.)")}
	if (symbol == 'movebtn') {		this._helpWindow.setWText("Choose how far to offset touch buttons to the left.")}
	if (symbol == 'port') {			this._helpWindow.setWText("Show or hide the main character's portrait on the right side of the screen.")}
	if (symbol == 'npcport') {		this._helpWindow.setWText("Show or hide NPC portraits when talking to NPC's or during events.")}
	if (symbol == 'savelabel') {	this._helpWindow.setWText("Choose whether to use default or customized savefile label when saving. If a custom label has not yet been inputted, the game will use the default label.\n\nNote: Inputting a new custom label will always use that label.")}
	if (symbol == 'gamepadtemp') {	this._helpWindow.setWText("Allows use of connected gamepads and joysticks to control the game.\n\nTurn this off if such devices are interfering with the game, or you want to use an external program to handle your controller inputs.")}
	if (symbol == 'resolution') {	this._helpWindow.setWText("Change window resolution scaling.\n\nWill only expand as large as the available screen size.")}
	if (symbol == 'gamepadfocus') {	this._helpWindow.setWText("Allow gamepad to function when game window isn't active.")}
	if (symbol == 'soundsgross') {	this._helpWindow.setWText("Prevent playing of unsettling fleshy sounds.")}

	if (symbol == 'defaultkeys') {	this._helpWindow.setWText("Reset " + keybind + " to default settings.")}
	if (symbol == 'prevkeys') {		this._helpWindow.setWText("Reset " + keybind + " to settings before entering menu.")}
	if (symbol == 'chgup') {		this._helpWindow.setWText("Change " + keybind + " for Up." + a)}
	if (symbol == 'chgleft') {		this._helpWindow.setWText("Change " + keybind + " for Left." + a)}
	if (symbol == 'chgright') {		this._helpWindow.setWText("Change " + keybind + " for Right." + a)}
	if (symbol == 'chgdown') {		this._helpWindow.setWText("Change " + keybind + " for Down." + a)}
	if (symbol == 'chgpgup') {		this._helpWindow.setWText("Change " + keybind + " for Up Right/Page Up." + a)}
	if (symbol == 'chgpgdown') {	this._helpWindow.setWText("Change " + keybind + " for Down Right/Page Down." + a)}
	if (symbol == 'chgok') {		this._helpWindow.setWText("Change " + keybind + " for Confirm." + a)}
	if (symbol == 'chgcancel') {	this._helpWindow.setWText("Change " + keybind + " for Cancel/Menu." + a)}
	if (symbol == 'chgshift') {		this._helpWindow.setWText("Change " + keybind + " for Log Display." + a)}
	if (symbol == 'chgseek') {		this._helpWindow.setWText("Change " + keybind + " for Seek." + a)}

	if (symbol == 'delete') {		this._helpWindow.setWText("Delete unneeded savefiles.")}
	if (symbol == 'keybinds') {		this._helpWindow.setWText("Change current bindings for keyboard.")}
	if (symbol == 'padbinds') {		this._helpWindow.setWText("Change current bindings for gamepad.")}
	if (symbol == 'general') {		this._helpWindow.setWText("Change gameplay settings.")}
	if (symbol == 'audio') {		this._helpWindow.setWText("Change audio settings.")}
};

Window_Options.prototype.processOk = function() {
	if (!ts(1,3,1)) {
		var index = this.index();
		var symbol = this.commandSymbol(index);
		var value = this.getConfigValue(symbol);
		
		if (!value) {
			switch (symbol) {
			case 'gamepadtemp':
				value = s(138)
				break;
			case 'movebtn':
				value = ConfigManager.movebtn
				break;
			case 'resolution':
				value = ConfigManager.resolution
				break;
			case 'soundsgross':
				value = ConfigManager.soundsgross
				break;
			}			
		}

		if (symbol == 'defaultkeys') {
			SoundManager.playOk()
			if (v(40) == 2) {
				setdefaultkeys()
				putkeystotemp()
			}
			else {
				setdefaultpads()
				putpadstotemp()
			}
			this.refresh()
		}
		else if (symbol == 'prevkeys') {
			SoundManager.playOk()
			if (v(40) == 2) {
				for (var i = 407; i <= 416; i++) { //prev keys
					vset(i-20,[]) //temp keys
					for (var j = 0; j < v(i).length; j++) {
						v(i-20).push(v(i)[j])
					}
				}
				puttemptokeys()
			}
			else {
				for (var i = 407; i <= 416; i++) { //prev pads
					vset(i-20,[]) //temp pads
					for (var j = 0; j < v(i).length; j++) {
						v(i-20).push(v(i)[j])
					}
				}
				puttemptopads()
			}
			this.refresh()
		}
		else if (symbol == 'delete') {
			SoundManager.playOk()
			$gameSelfSwitches.setValue([3, 1, 2], true)
			SceneManager.push(Scene_Delete);
		}
		else if (symbol == 'general') {
			SoundManager.playOk()
			vset(40,1)

			this.refresh()
			this.select(0)
		}
		else if (symbol == 'audio') {
			SoundManager.playOk()
			vset(40,4)
	
			this.refresh()
			this.select(0)
		}
		else if (symbol == 'keybinds') {
			SoundManager.playOk()
			vset(40,2)

			putkeystotemp()
			putkeystoprev()
	
			this.refresh()
			this.select(0)
		}
		else if (symbol == 'padbinds') {
			if (ConfigManager.gamepad) {
				SoundManager.playOk()
				vset(40,3)

				putpadstotemp() //only happens if correct menu slot
				putpadstoprev()

				this.refresh()
				this.select(0)
			}
			else {
				SoundManager.playBuzzer()
			}
		}
		else if (this.isVolumeSymbol(symbol)) { //not else if!
	//        value -= this.volumeOffset();
			if (value < 0) {
				value = 100;
			}
			value = value.clamp(0, 100);
			this.changeValue(symbol, value);
		}
		else if (symbol == 'movebtn') {
			if (ConfigManager.movebtn < 50) {
				value = ConfigManager.movebtn + 10
			}
			else {
				value = 0
			}
			this.changeValue(symbol, value);
		}
		else if (symbol == 'resolution') {
			SoundManager.playOk()
			ConfigManager.resolution += 1
			if (ConfigManager.resolution >= 11) {ConfigManager.resolution = 0}
			chgresolution()
			this.redrawItem(this.findSymbol(symbol));
		}
		else if (v(40) == 2 || v(40) == 3) {
			SoundManager.playOk()
			$gameSelfSwitches.setValue([3, 1, 1], true)
			this.redrawItem(this.findSymbol(symbol));
		}
		else {
			this.changeValue(symbol, !value);
		}
	}

};

var nk_Window_Options_cursorup = Window_Options.prototype.cursorUp
Window_Options.prototype.cursorUp = function(wrap) {
	if (!ts(1,3,1)) {
		nk_Window_Options_cursorup.call(this, wrap)
	}
};

var nk_Window_Options_cursordown = Window_Options.prototype.cursorDown
Window_Options.prototype.cursorDown = function(wrap) {
	if (!ts(1,3,1)) {
		nk_Window_Options_cursordown.call(this, wrap)
	}
};


Window_Options.prototype.cursorRight = function(wrap) {
	if (v(40) != 0) {
		var index = this.index();
		var symbol = this.commandSymbol(index);
		var value = this.getConfigValue(symbol);
		if (this.isVolumeSymbol(symbol)) {
			value += this.volumeOffset();
			value = value.clamp(0, 100);
			this.changeValue(symbol, value);
		}
		else if (symbol == 'movebtn') {
			if (ConfigManager.movebtn < 50) {
				value = ConfigManager.movebtn+10
				this.changeValue(symbol, value);
			}
		}
		else if (symbol == 'resolution') {
			if (ConfigManager.resolution != 10) {
				SoundManager.playOk()
				ConfigManager.resolution += 1
				chgresolution()
			}
			this.redrawItem(this.findSymbol(symbol));
		}
		else if (v(40) == 2 || v(40) == 3) {
		}
		else {
			this.changeValue(symbol, true);
		}
	}
};


Window_Options.prototype.cursorLeft = function(wrap) {
	if (v(40) != 0) {
		var index = this.index();
		var symbol = this.commandSymbol(index);
		var value = this.getConfigValue(symbol);
		if (this.isVolumeSymbol(symbol)) {
			value -= this.volumeOffset();
			value = value.clamp(0, 100);
			this.changeValue(symbol, value);
		}
		else if (symbol == 'movebtn') {
			if (ConfigManager.movebtn > 0) {
				value = ConfigManager.movebtn-10
				this.changeValue(symbol, value);
			}
		}
		else if (symbol == 'resolution') {
			if (ConfigManager.resolution != 0) {
				SoundManager.playOk()
				ConfigManager.resolution -= 1
				chgresolution()
			}
			this.redrawItem(this.findSymbol(symbol));		
		}
		else if (v(40) == 2 || v(40) == 3) {
		}
		else {
			this.changeValue(symbol, false);
		}
	}
};

Window_Options.prototype.volumeOffset = function() {
	if (Input.isPressed('shift')) {
		return 20
	}
	else {
		return 5
	}
};

Window_Options.prototype.changeValue = function(symbol, value) {
    var lastValue = this.getConfigValue(symbol);
    if (lastValue !== value) {
		switch (symbol) {
		case 'savelabel':
			sset(34, !value)
			break;
		case 'gamepadtemp':
			sset(137, !value)
			break;
		}
		
        this.setConfigValue(symbol, value);
        this.redrawItem(this.findSymbol(symbol));
		
		
		if (symbol != 'delete' && symbol != 'keybinds') {
			SoundManager.playOk();
		}
		if (symbol == 'soundsgross') {
			if (value == true) {
				if (AudioManager._currentBgs && AudioManager._currentBgs["name"] == "meat-productionnow") {
					AudioManager.fadeOutBgs(1)
				}
				if (AudioManager._currentBgsEx[0] && AudioManager._currentBgsEx[0]["name"] == "meat-productionnow") {
					AudioManager.fadeBgsEx(1)
				}
			}
			else {
				restorebgs()
			}
		}
    }
};


Window_Command.prototype.numVisibleRows = function() {
    return Math.min(6, Math.ceil(this.maxItems() / this.maxCols()))
};



Input.update = function() {
	if (document.hasFocus() || ConfigManager.gamepadfocus) {
		this._pollGamepads();
	}
    if (this._currentState[this._latestButton]) {
        this._pressedTime++;
    } else {
        this._latestButton = null;
    }
    for (var name in this._currentState) {
        if (this._currentState[name] && !this._previousState[name]) {
            this._latestButton = name;
            this._pressedTime = 0;
            this._date = Date.now();
        }
        this._previousState[name] = this._currentState[name];
    }
    this._updateDirection();
};

